/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.base.VWDebug;
import java.util.EventObject;
import java.util.Vector;

public class VWScopeChangeEvent
extends EventObject {
    private static final int TYPE_MIN = 1;
    public static final int TYPE_ROSTER = 1;
    public static final int TYPE_QUEUE = 2;
    public static final int TYPE_EVENTLOG = 3;
    public static final int TYPE_STATISTICS = 4;
    private static final int TYPE_MAX = 4;
    protected int m_nType = 0;
    protected IVWTableDefinition m_definition = null;
    protected String[] m_repositoryNames = null;
    protected String[] m_availableColumns = null;
    protected String[] m_defaultColumns = null;

    public VWScopeChangeEvent(Object source) {
        super(source);
    }

    public String[] getAvailableColumns() {
        return this.m_availableColumns;
    }

    public void setAvailableColumns(String[] columns) {
        this.m_availableColumns = columns;
    }

    public String[] getDefaultColumns() {
        return this.m_defaultColumns;
    }

    public void setDefaultColumns(String[] columns) {
        this.m_defaultColumns = columns;
    }

    public IVWTableDefinition getDefinitionObject() {
        return this.m_definition;
    }

    public void setDefinitionObject(IVWTableDefinition definition) {
        try {
            this.m_definition = definition;
            this.m_availableColumns = null;
            if (this.m_definition != null) {
                Vector<String> columns = new Vector<String>();
                VWExposedFieldDefinition[] fields = this.m_definition.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    columns.addElement(fields[i].getName());
                }
                this.m_availableColumns = new String[columns.size()];
                columns.copyInto(this.m_availableColumns);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String[] getRespositoryNames() {
        return this.m_repositoryNames;
    }

    public void setRespositoryNames(String[] names) {
        this.m_repositoryNames = names;
    }

    public int getType() {
        return this.m_nType;
    }

    public void setType(int nType) throws VWException {
        if (nType < 1 || nType > 4) {
            throw new VWException("vw.toolkit.utils.query.InvalidScopeType", "Scope type {0} is not a valid type.", new Integer(this.m_nType));
        }
        this.m_nType = nType;
    }
}

